#include "q3la.h"

q3la_main::q3la_main()
{
}

q3la_main::~q3la_main()
{
}

void q3la_main::run (int argc, char** argv) 
{
#ifdef TEST
	_chdir ("c:\\Games\\Quake III Arena\\baseq3");
//	_chdir ("c:\\");
//	config.no_bots = true;
	argc = 2;
	argv[1] = "games.log";
#endif

	if (argc < 2) {
		help();
	}

	version_info();

	// Get start time

	clock_t start, finish;   
	start = clock();

	config.read_options (argc, argv);

	if (config.q3ladata == true) { // delete q3ladata.txt
		outputfile deldata; 
		deldata.open("q3ladata.txt");
		deldata.close();
	}

	analyze (argv[1]);

	// Get finish time, output
	
	finish = clock();
	printf( "\n%.2f seconds elapsed", ((double) (finish - start) / CLOCKS_PER_SEC));

	if (config.open_after == true) { // NT / 9x check!!!
		system ("start players.htm"); //9x
		system ("players.htm"); // NT
	}
}

void q3la_main::analyze (char* pathstr) 
{
/*
	struct tm *newtime;
	time_t long_time;

	time( &long_time );                
	newtime = localtime( &long_time );
*/

	printf ("\nParsing %s\n", pathstr);

	FILE* logfile = fopen (pathstr, "r");
	if (logfile == 0) {
		error::msg_and_exit ("q3la_main::analyze - can't open games.log");
	}

	fseek (logfile, 0, SEEK_END);
	int logfilesize = ftell (logfile);
	fseek (logfile, 0, SEEK_SET);

	// Open output file for all games

#ifndef __LINUX_PLATFORM__
	_mkdir ("q3la_games");
#else
	mkdir ("q3la_games", S_IRWXU);
#endif

	printf ("\nWriting game stats to \"games.htm\"        ");

	outputfile out_games_total;
	out_games_total.open ("games.htm");
	html::html_header (&out_games_total);
	html::line (&out_games_total, "<a href=\"players.htm\"><font color=\"#FF0000\" size=\"4\"><b>Player list</b></font></a>");

	resultdata_total results_total;
	int	gamecount = 0;

	resultdata result(&config);
	analyzedemo analyze (logfile, &result, &config);
	for (;;) {
		result.init();
		if (analyze.parse() == 0) { // parse next game
			break;
		}
		result.sort_players(so_skill); // sort players for each game
		gamecount++;

		int rel_pos = 100 * ftell(logfile) / logfilesize;
		printf ("\b\b\b\b\b\b\b(%3i %%)", rel_pos); // progress indication

		output_game(gamecount, &result, &out_games_total); 

		results_total.add_results (&(result)); // add to total results 
	}
	printf ("\b\b\b\b\b\b\b(100 %%)"); // progress indication
	
	html::html_footer(&out_games_total);
	out_games_total.close();

	if (config.q3ladata == true) { 
		printf ("\nWriting q3ladata.txt"); // output of this is delayed to actual writing
	}

	// Output total player results

	outputfile outfile;
	outfile.open ("players.htm");
	printf ("\nWriting player stats to \"players.htm\"");

	results_total.sort_players (config.sortorder_players); // sort all players
	output out_total (&results_total, &outfile, &config);
	printf ("\n");

	outfile.close ();

	fclose (logfile);
}

int q3la_main::output_game(int gamecount, resultdata* result, outputfile* out_games_total)
{
	// delete bots
	if (config.no_bots == true) {
		result->delete_bots();
	}

	// Output to "games.htm"
	output out_total (result, out_games_total, &config);
	html::line_header(out_games_total);
	out_games_total->write ("<b><font size=\"4\"><a href=\"q3la_games/game %i.htm\"><font color=\"#FF0000\">Game %i</font></a><br>(%s)</font></b>", gamecount, gamecount, result->mapname);
	html::line_footer(out_games_total);
	out_total.list_players_html();
	
	// Open output file for current game
	_chdir ("q3la_games");
	char gamefile[16];
	sprintf (gamefile, "game %i.htm", gamecount);
	outputfile out_game_current;
	out_game_current.open (gamefile);
	html::html_header(&out_game_current);
	
	// Output to "game <x>.htm"
	output out_current (result, &(out_game_current), &config);
	html::line (&out_game_current, "<a href=\"..\\games.htm\"><font color=\"#FF0000\" size=\"4\"><b>Game list</b></font></a>");
	html::line (&out_game_current, "<b><font color=\"#FF0000\" size=\"4\">Game %i</font></b>", gamecount);
	out_current.game_info();
	out_current.list_players_html();
	for (int i = 0; i < MAX_WEAPONS; i++) {
		out_current.table_kills_html(i);
	}
	if (config.q3ladata == true) {
		out_current.game_data(gamecount);
	}
	
	// Close current game file
	html::html_footer(&out_game_current);
	out_game_current.close();
	_chdir ("..");

	return 0;
}

void q3la_main::help () 
{
	version_info();
    printf ("\nUsage: q3la <logfile> [OPTIONS]\n");
    printf ("\nOptions:\n");
	printf ("\n/A               open results after analysis");
	printf ("\n/B               don't include bots in results");
	printf ("\n/D               write data file (q3ladata.txt)");
	printf ("\n/O               sortorder (S-kill, F-rags, K-ills, N-ame (default: /OS)");
	printf ("\n\nOptions can be specified in upper or lower case with the prefix '/' or '-'");
	printf ("\n");
	exit (1);
}

void q3la_main::version_info()
{
    printf ("\n%s %s, %s\n%s\n", helpstr1, version, date, helpstr2);
	printf ("\n***   THIS IS A DEVELOPMENT BUILD!   ***");
	printf ("\n*** ONLY WORKS WITH Q3A'S GAMES.LOG! ***\n");
}
